# Rails Chat App with Action Cable

A simple real-time chat application built with Rails 7.2 and Action Cable.

## What you can build with this Blueprint
- Real-time chat application with WebSocket
- Multiple chat rooms
- User presence detection (who's online)
- Message history
- Simple user authentication
- Responsive design with Tailwind CSS

## Target Stack
- Language: Ruby 3.2+
- Framework: Rails 7.2
- Real-time: Action Cable (WebSocket)
- CSS: Tailwind CSS
- DB: PostgreSQL (Docker container)
- Cache: Redis (for Action Cable adapter)
- Editor: VS Code
- AI Agent: Claude 4.5

## Features
✅ User authentication (username/password)  
✅ Create and join chat rooms  
✅ Real-time messaging via WebSocket  
✅ User presence (online/offline status)  
✅ Message history  
✅ Responsive mobile-friendly UI  
✅ Emoji support in messages  

## How to use this Blueprint

### For new Rails project
1. Download and extract this Blueprint
2. Place `example-chat-blueprint/` in your desired project location
3. Open the directory in VS Code
4. Let the AI agent read `example-chat-blueprint/README.md` first
5. Agent will create Rails app in the same parent directory
6. Execute implementation tasks in `docs/06_tasks.md` sequentially

### For existing Rails project
1. Download and extract this Blueprint
2. Place `example-chat-blueprint/` in your Rails project root (same level as `app/`, `config/`)
3. Optionally add to `.gitignore` if you don't want to commit design docs
4. Let the AI agent read `example-chat-blueprint/README.md`
5. Agent will implement features into your existing Rails app

### Directory structure example
```
my-chat-project/                # Project root
├── example-chat-blueprint/     # This Blueprint (design docs)
│   ├── README.md
│   ├── blueprint.yml
│   └── docs/
│       ├── 01_requirements.md
│       ├── 02_architecture.md
│       ├── 03_data_model.md
│       ├── 04_user_flows.md
│       ├── 05_agent_usage.md
│       ├── 06_tasks.md
│       └── 99_agent_notes.md
└── chat-app/                   # Rails app (created by agent)
    ├── app/
    ├── config/
    ├── db/
    └── ...
```

## Quick Start (After Implementation)

### Start Redis (required for Action Cable)
```bash
redis-server
```

### Start Rails server
```bash
cd chat-app
bin/rails server
```

### Visit the app
Open http://localhost:3000 in your browser

## Development Flow
1. Read `docs/05_agent_usage.md` to understand how to work with AI agents
2. Follow tasks in `docs/06_tasks.md` sequentially
3. Test each feature after implementation
4. Refer to `docs/99_agent_notes.md` for tips and gotchas

## Testing Real-time Features
- Open multiple browser windows (or use incognito mode)
- Sign in as different users
- Join the same room and start chatting
- Messages should appear in real-time across all windows
- User presence should update when users join/leave

## Common Issues
- **WebSocket not connecting**: Check Redis is running
- **Messages not appearing**: Check browser console for JS errors
- **Cable connection closed**: Verify Action Cable is configured in `config/cable.yml`

## Next Steps (Post-MVP)
- Direct messages between users
- File/image sharing in chat
- Message reactions (like, emoji reactions)
- Typing indicators
- Read receipts
- Push notifications
- Voice/video chat integration
- Chat room moderation features

## Learn More
- [Action Cable Overview](https://guides.rubyonrails.org/action_cable_overview.html)
- [WebSocket Protocol](https://developer.mozilla.org/en-US/docs/Web/API/WebSockets_API)
- [Hotwire Turbo](https://turbo.hotwired.dev/)
