# Requirements

## Functional Requirements (MVP)

### User Authentication
- **Sign up** with username and password
- **Sign in** to access chat rooms
- **Sign out** functionality
- **Current user** detection and display
- Simple password authentication (bcrypt)

### Chat Rooms
- **List all rooms** (public rooms visible to all logged-in users)
- **Create new room** with name and description
- **Join existing room** by clicking on it
- **Leave room** to go back to room list
- **Room information** (name, description, participant count)

### Real-time Messaging
- **Send messages** in a chat room
- **Receive messages** in real-time via WebSocket
- **Display sender** username with each message
- **Timestamp** for each message
- **Message history** (load previous messages when joining)
- **Scroll to bottom** automatically when new messages arrive
- **Emoji support** in messages

### User Presence
- **Online status** - show who's currently in a room
- **User list** - display active participants
- **Join/leave notifications** - notify when users enter/exit
- **Active user count** in room list

### UI/UX
- **Responsive design** - works on mobile and desktop
- **Clean interface** with Tailwind CSS
- **Loading states** for async operations
- **Error messages** for failed actions
- **Empty states** for no messages/rooms
- **Message input** with send button and Enter key support

## Non-Functional Requirements

### Performance
- Messages delivered within 100ms
- Handle 100+ concurrent users per room
- Efficient database queries (n+1 prevention)
- Redis caching for Action Cable

### Security
- Password hashing with bcrypt
- CSRF protection (Rails default)
- WebSocket origin validation
- Sanitize user input (prevent XSS)
- Authenticated WebSocket connections

### Reliability
- Graceful WebSocket reconnection
- Connection status indicator
- Error recovery for failed sends
- Data persistence (messages saved to DB)

### Usability
- Intuitive navigation
- Clear visual hierarchy
- Accessible keyboard shortcuts
- Mobile-friendly touch targets
- Readable text contrast

## Out of Scope (v1)

### Features Not Included
- ❌ Direct messages (1-on-1 chat)
- ❌ File/image uploads
- ❌ Message editing/deletion
- ❌ Message reactions
- ❌ Typing indicators
- ❌ Read receipts
- ❌ User profiles/avatars
- ❌ Email verification
- ❌ Password reset
- ❌ OAuth login
- ❌ Private rooms (invitation-only)
- ❌ Room ownership/moderation
- ❌ Search messages
- ❌ Message threading
- ❌ Voice/video chat
- ❌ Push notifications
- ❌ Mobile app

## User Stories

### As a visitor
- I want to sign up with a username so I can join chats
- I want to sign in with my credentials

### As a logged-in user
- I want to see all available chat rooms
- I want to create a new room with a name
- I want to join a room and see message history
- I want to send messages that appear instantly for others
- I want to see who else is in the room
- I want to see new messages in real-time without refreshing
- I want to be notified when users join/leave the room
- I want to leave a room and return to the room list
- I want to sign out when I'm done

## Technical Requirements

### Rails Version
- Rails 7.2+
- Ruby 3.2+

### Dependencies
- `bcrypt` - password hashing
- `redis` - Action Cable adapter
- `tailwindcss-rails` - styling
- `turbo-rails` - Hotwire Turbo
- `stimulus-rails` - JavaScript framework

### Database
- PostgreSQL 14+
- Proper indexes on foreign keys
- Timestamps on all tables

### Action Cable
- Redis adapter for production
- Async adapter for development/test
- Authenticated cable connections
- Channel-based messaging

### Browser Support
- Modern evergreen browsers (Chrome, Firefox, Safari, Edge)
- WebSocket support required
- JavaScript enabled

## Success Criteria

### MVP is complete when:
1. ✅ Users can sign up and sign in
2. ✅ Users can create and join rooms
3. ✅ Messages appear in real-time via WebSocket
4. ✅ Message history loads when joining
5. ✅ User presence is visible (who's online)
6. ✅ UI is responsive on mobile and desktop
7. ✅ No major bugs or crashes
8. ✅ WebSocket reconnects automatically on disconnect

### Quality Metrics
- Page load time < 2 seconds
- Message delivery < 100ms
- Zero data loss on disconnect/reconnect
- All user inputs sanitized
- No console errors in browser
