# User Flows

## Overview
This document describes the main user interaction flows for the chat application.

---

## Flow 1: User Registration

```
┌──────────────────────────────────────────────────────────────┐
│ 1. Visit Homepage (not logged in)                            │
└───────────────────────────────┬──────────────────────────────┘
                                │
                                ↓
┌──────────────────────────────────────────────────────────────┐
│ 2. Click "Sign Up" button                                    │
└───────────────────────────────┬──────────────────────────────┘
                                │
                                ↓
┌──────────────────────────────────────────────────────────────┐
│ 3. Fill out registration form:                               │
│    - Username (3-20 characters)                              │
│    - Password (min 6 characters)                             │
│    - Password confirmation                                   │
└───────────────────────────────┬──────────────────────────────┘
                                │
                                ↓
┌──────────────────────────────────────────────────────────────┐
│ 4. Submit form                                                │
└───────────────────────────────┬──────────────────────────────┘
                                │
                    ┌───────────┴───────────┐
                    │                       │
                    ↓                       ↓
        ┌─────────────────────┐  ┌─────────────────────┐
        │ Validation fails     │  │ Validation succeeds │
        │ Show errors          │  │ Create user         │
        │ Stay on form         │  │ Log in user         │
        └───────┬──────────────┘  └───────┬─────────────┘
                │                         │
                │                         ↓
                │              ┌─────────────────────┐
                │              │ Redirect to         │
                │              │ Room list page      │
                │              └─────────────────────┘
                │                         │
                └─────────────────────────┘
```

**Success Criteria:**
- User account created in database
- Password securely hashed with bcrypt
- User automatically logged in
- Session cookie set
- Redirected to room list

---

## Flow 2: User Login

```
┌──────────────────────────────────────────────────────────────┐
│ 1. Visit Homepage or click "Sign In"                         │
└───────────────────────────────┬──────────────────────────────┘
                                │
                                ↓
┌──────────────────────────────────────────────────────────────┐
│ 2. Fill out login form:                                      │
│    - Username                                                 │
│    - Password                                                 │
└───────────────────────────────┬──────────────────────────────┘
                                │
                                ↓
┌──────────────────────────────────────────────────────────────┐
│ 3. Submit form                                                │
└───────────────────────────────┬──────────────────────────────┘
                                │
                    ┌───────────┴───────────┐
                    │                       │
                    ↓                       ↓
        ┌─────────────────────┐  ┌─────────────────────┐
        │ Invalid credentials  │  │ Valid credentials   │
        │ Show error message   │  │ Set session         │
        │ Stay on login page   │  │ Log in user         │
        └───────┬──────────────┘  └───────┬─────────────┘
                │                         │
                │                         ↓
                │              ┌─────────────────────┐
                │              │ Redirect to         │
                │              │ Room list page      │
                │              └─────────────────────┘
                │                         │
                └─────────────────────────┘
```

**Success Criteria:**
- User authenticated via bcrypt
- Session cookie created
- Redirected to room list
- Username displayed in navbar

---

## Flow 3: Browse and Join Chat Room

```
┌──────────────────────────────────────────────────────────────┐
│ 1. User on Room List page (logged in)                        │
│    - See all available rooms                                 │
│    - See room names, descriptions                            │
│    - See active user counts                                  │
└───────────────────────────────┬──────────────────────────────┘
                                │
                                ↓
┌──────────────────────────────────────────────────────────────┐
│ 2. Click on a room to join                                   │
└───────────────────────────────┬──────────────────────────────┘
                                │
                                ↓
┌──────────────────────────────────────────────────────────────┐
│ 3. Navigate to Room Show page                                │
│    - Load message history (last 100 messages)                │
│    - Establish WebSocket connection                          │
│    - Subscribe to RoomChannel                                │
└───────────────────────────────┬──────────────────────────────┘
                                │
                                ↓
┌──────────────────────────────────────────────────────────────┐
│ 4. User sees:                                                 │
│    - Room name and description                               │
│    - Message history                                          │
│    - List of online users                                    │
│    - Message input box                                       │
│    - "Leave Room" button                                     │
└───────────────────────────────┬──────────────────────────────┘
                                │
                                ↓
┌──────────────────────────────────────────────────────────────┐
│ 5. Broadcast "user_joined" event                             │
│    - Notify all other users in room                          │
│    - Update online user list for everyone                    │
└──────────────────────────────────────────────────────────────┘
```

**Success Criteria:**
- WebSocket connection established
- User subscribed to room channel
- Message history loaded
- User appears in online list
- Join notification visible to others

---

## Flow 4: Send and Receive Messages

```
┌──────────────────────────────────────────────────────────────┐
│ 1. User in chat room                                          │
└───────────────────────────────┬──────────────────────────────┘
                                │
                                ↓
┌──────────────────────────────────────────────────────────────┐
│ 2. Type message in input box                                  │
└───────────────────────────────┬──────────────────────────────┘
                                │
                                ↓
┌──────────────────────────────────────────────────────────────┐
│ 3. Click "Send" or press Enter                               │
└───────────────────────────────┬──────────────────────────────┘
                                │
                                ↓
┌──────────────────────────────────────────────────────────────┐
│ 4. Client sends via Turbo form submit                        │
└───────────────────────────────┬──────────────────────────────┘
                                │
                                ↓
┌──────────────────────────────────────────────────────────────┐
│ 5. Server (MessagesController#create):                       │
│    - Validate message                                         │
│    - Save to database                                         │
│    - Broadcast via Action Cable                              │
└───────────────────────────────┬──────────────────────────────┘
                                │
                                ↓
┌──────────────────────────────────────────────────────────────┐
│ 6. Action Cable broadcasts to all subscribers                │
│    - Message sent via RoomChannel                            │
│    - All connected clients receive                           │
└───────────────────────────────┬──────────────────────────────┘
                                │
                                ↓
┌──────────────────────────────────────────────────────────────┐
│ 7. Each client receives message:                             │
│    - Append message to chat window                           │
│    - Show username and timestamp                             │
│    - Auto-scroll to bottom                                   │
│    - Clear input box (for sender)                            │
└──────────────────────────────────────────────────────────────┘
```

**Real-time Flow:**
```
User A                      Server                    User B
  │                            │                         │
  │──── Send message ─────────→│                         │
  │                            │                         │
  │                            │──── Broadcast ─────────→│
  │                            │                         │
  │←─── Message appears ───────│                         │
  │                            │                         │
  │                            │                         │
  │                  Message appears ───────────────────→│
```

**Success Criteria:**
- Message saved to database
- Message appears instantly for all users
- Sender's input cleared
- Auto-scroll to latest message
- Timestamp displayed
- Sender username shown

---

## Flow 5: Leave Chat Room

```
┌──────────────────────────────────────────────────────────────┐
│ 1. User clicks "Leave Room" button                           │
└───────────────────────────────┬──────────────────────────────┘
                                │
                                ↓
┌──────────────────────────────────────────────────────────────┐
│ 2. WebSocket unsubscribes from RoomChannel                   │
└───────────────────────────────┬──────────────────────────────┘
                                │
                                ↓
┌──────────────────────────────────────────────────────────────┐
│ 3. Broadcast "user_left" event                               │
│    - Notify remaining users                                  │
│    - Update online user list                                 │
└───────────────────────────────┬──────────────────────────────┘
                                │
                                ↓
┌──────────────────────────────────────────────────────────────┐
│ 4. Navigate back to Room List                                │
└──────────────────────────────────────────────────────────────┘
```

**Success Criteria:**
- User unsubscribed from channel
- Leave notification sent to others
- User removed from online list
- Redirected to room list

---

## Flow 6: Create New Chat Room

```
┌──────────────────────────────────────────────────────────────┐
│ 1. User on Room List page                                    │
└───────────────────────────────┬──────────────────────────────┘
                                │
                                ↓
┌──────────────────────────────────────────────────────────────┐
│ 2. Click "Create New Room" button                            │
└───────────────────────────────┬──────────────────────────────┘
                                │
                                ↓
┌──────────────────────────────────────────────────────────────┐
│ 3. Fill out new room form:                                   │
│    - Room name (required, 1-50 chars)                        │
│    - Description (optional, max 200 chars)                   │
└───────────────────────────────┬──────────────────────────────┘
                                │
                                ↓
┌──────────────────────────────────────────────────────────────┐
│ 4. Submit form                                                │
└───────────────────────────────┬──────────────────────────────┘
                                │
                    ┌───────────┴───────────┐
                    │                       │
                    ↓                       ↓
        ┌─────────────────────┐  ┌─────────────────────┐
        │ Validation fails     │  │ Validation succeeds │
        │ (name taken/invalid) │  │ Create room         │
        │ Show errors          │  │ Save to database    │
        └───────┬──────────────┘  └───────┬─────────────┘
                │                         │
                │                         ↓
                │              ┌─────────────────────┐
                │              │ Redirect to new     │
                │              │ room's chat page    │
                │              │ User auto-joins     │
                │              └─────────────────────┘
                │                         │
                └─────────────────────────┘
```

**Success Criteria:**
- Room created in database
- Room appears in room list
- Creator automatically joins room
- Room accessible to all users

---

## Flow 7: User Logout

```
┌──────────────────────────────────────────────────────────────┐
│ 1. User clicks "Sign Out" in navbar                          │
└───────────────────────────────┬──────────────────────────────┘
                                │
                                ↓
┌──────────────────────────────────────────────────────────────┐
│ 2. Submit logout form (DELETE request)                       │
└───────────────────────────────┬──────────────────────────────┘
                                │
                                ↓
┌──────────────────────────────────────────────────────────────┐
│ 3. Server destroys session                                   │
│    - Clear session cookie                                     │
│    - WebSocket disconnects                                   │
└───────────────────────────────┬──────────────────────────────┘
                                │
                                ↓
┌──────────────────────────────────────────────────────────────┐
│ 4. Redirect to sign in page                                  │
└───────────────────────────────┬──────────────────────────────┘
                                │
                                ↓
┌──────────────────────────────────────────────────────────────┐
│ 5. Show flash message: "Signed out successfully"            │
└──────────────────────────────────────────────────────────────┘
```

**Success Criteria:**
- Session cleared
- User no longer authenticated
- WebSocket disconnected
- Redirected to login page

---

## Flow 8: Real-time Presence Updates

```
User A (Browser)              Server                 User B (Browser)
      │                          │                           │
      │──── Join room ───────────→                           │
      │                          │                           │
      │                          │─── Broadcast joined ─────→│
      │                          │                           │
      │                          │                  Update user list
      │                          │                           │
      │                          │←──── User B joins ────────│
      │                          │                           │
      │←─── Broadcast joined ────│                           │
      │                          │                           │
Update user list                 │                           │
      │                          │                           │
      │                          │                           │
      │──── Leave room ──────────→                           │
      │                          │                           │
      │                          │─── Broadcast left ───────→│
      │                          │                           │
      │                          │                  Update user list
```

**Success Criteria:**
- Join events broadcast in real-time
- Leave events broadcast in real-time
- User list updated automatically
- No page refresh required

---

## Error Handling Flows

### Connection Lost Flow
```
1. User loses internet connection
2. WebSocket disconnects
3. Show "Connection lost" indicator
4. Attempt automatic reconnection
5. On success: "Connected" indicator
6. On failure: "Reconnecting..." with manual retry button
```

### Message Send Failure Flow
```
1. User sends message
2. Network error or validation failure
3. Show error message
4. Keep message in input box
5. Allow user to retry
```

### Invalid Session Flow
```
1. User's session expires
2. Attempt to access protected page
3. Redirect to sign in page
4. Show flash: "Please sign in to continue"
5. After login, redirect to originally requested page
```

---

## Navigation Map

```
                         ┌──────────────────┐
                         │   Sign In Page   │
                         └────────┬─────────┘
                                  │
                    ┌─────────────┴─────────────┐
                    │                           │
                    ↓                           ↓
        ┌──────────────────┐        ┌──────────────────┐
        │  Sign Up Page    │        │  Room List Page  │
        └──────────────────┘        └────────┬─────────┘
                    │                        │
                    └────────────────┬───────┘
                                     │
                                     ↓
                        ┌─────────────────────────┐
                        │  Chat Room Page         │
                        │  (with WebSocket)       │
                        └─────────────────────────┘
                                     │
                                     │ Leave Room
                                     │
                                     ↓
                        ┌─────────────────────────┐
                        │  Back to Room List      │
                        └─────────────────────────┘
```

## Mobile Considerations

### Touch Interactions
- Large tap targets (min 44x44px)
- Swipe to scroll message history
- Pull-to-refresh for room list
- Touch-friendly send button

### Mobile-specific Flows
- Bottom-anchored message input (above keyboard)
- Collapsible user list sidebar
- Compact message layout
- Auto-hide header on scroll

---

## Accessibility Considerations

### Keyboard Navigation
- Tab through all interactive elements
- Enter to send message
- Escape to close modals
- Arrow keys to navigate messages

### Screen Reader Support
- ARIA labels on buttons
- Message announcements
- Status indicators
- Focus management
